/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.api.v3.item;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.item.CcaNbtType;
import dev.onyxstudios.cca.api.v3.item.ItemTagInvalidationListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ItemComponent
implements Component,
ItemTagInvalidationListener {
    @Nullable
    private class_2487 rootTag;
    protected final class_1799 stack;
    private String rootTagKey;

    public ItemComponent(class_1799 stack) {
        this.stack = stack;
    }

    public ItemComponent(class_1799 stack, ComponentKey<?> key) {
        this(stack);
        this.setRootTagKey(key.getId().toString());
    }

    protected String getRootTagKey() {
        return this.rootTagKey;
    }

    @Nullable
    protected class_2487 getRootTag() {
        return this.rootTag;
    }

    protected class_2487 getOrCreateRootTag() {
        if (this.rootTag != null) {
            return this.rootTag;
        }
        this.rootTag = this.stack.method_7911(this.getRootTagKey());
        return this.rootTag;
    }

    protected boolean getBoolean(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag != null && rootTag.method_10577(key);
    }

    protected int getInt(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? 0 : rootTag.method_10550(key);
    }

    protected long getLong(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? 0L : rootTag.method_10537(key);
    }

    protected float getFloat(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? 0.0f : rootTag.method_10583(key);
    }

    protected double getDouble(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? 0.0 : rootTag.method_10574(key);
    }

    protected String getString(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? "" : rootTag.method_10558(key);
    }

    protected <T extends class_2520> List<T> getList(String key, CcaNbtType<T> type) {
        class_2487 rootTag = this.getRootTag();
        class_2499 ts = rootTag == null ? Collections.emptyList() : rootTag.method_10554(key, type.getId());
        return ts;
    }

    protected class_2499 getList(String key, int type) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? new class_2499() : rootTag.method_10554(key, type);
    }

    protected class_2487 getCompound(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? new class_2487() : rootTag.method_10562(key);
    }

    @Nullable
    protected UUID getUuid(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag != null && rootTag.method_25928(key) ? rootTag.method_25926(key) : null;
    }

    protected void putBoolean(String key, boolean value) {
        if (value) {
            this.getOrCreateRootTag().method_10556(key, true);
        } else {
            this.remove(key);
        }
    }

    protected void putInt(String key, int value) {
        if (value != 0) {
            this.getOrCreateRootTag().method_10569(key, value);
        } else {
            this.remove(key);
        }
    }

    protected void putLong(String key, long value) {
        if (value != 0L) {
            this.getOrCreateRootTag().method_10544(key, value);
        } else {
            this.remove(key);
        }
    }

    protected void putFloat(String key, float value) {
        if (value != 0.0f) {
            this.getOrCreateRootTag().method_10548(key, value);
        } else {
            this.remove(key);
        }
    }

    protected void putDouble(String key, double value) {
        if (value != 0.0) {
            this.getOrCreateRootTag().method_10549(key, value);
        } else {
            this.remove(key);
        }
    }

    protected void putString(String key, String value) {
        if (!value.isEmpty()) {
            this.getOrCreateRootTag().method_10582(key, value);
        } else {
            this.remove(key);
        }
    }

    protected void putList(String key, class_2499 value) {
        if (!value.isEmpty()) {
            this.getOrCreateRootTag().method_10566(key, (class_2520)value);
        } else {
            this.remove(key);
        }
    }

    protected void putCompound(String key, class_2487 value) {
        if (!value.method_33133()) {
            this.getOrCreateRootTag().method_10566(key, (class_2520)value);
        } else {
            this.remove(key);
        }
    }

    protected void putUuid(String key, UUID value) {
        this.getOrCreateRootTag().method_25927(key, value);
    }

    protected void remove(String key) {
        class_2487 rootTag = this.getRootTag();
        if (rootTag != null) {
            rootTag.method_10551(key);
            if (rootTag.method_33133()) {
                this.stack.method_7983(this.getRootTagKey());
                this.rootTag = null;
            }
        }
    }

    protected boolean hasTag(String key) {
        class_2487 rootTag = this.getRootTag();
        return rootTag != null && rootTag.method_10545(key);
    }

    protected boolean hasTag(String key, int type) {
        class_2487 rootTag = this.getRootTag();
        return rootTag != null && rootTag.method_10573(key, type);
    }

    protected boolean hasTag(String key, CcaNbtType<?> type) {
        return this.hasTag(key, type.getId());
    }

    @Nullable
    protected class_2520 getTag(String key) {
        class_2487 rootTag = this.getRootTag();
        if (rootTag == null) {
            return null;
        }
        return rootTag.method_10580(key);
    }

    @Nullable
    protected class_2520 getTag(String key, int type) {
        class_2520 tag = this.getTag(key);
        if (tag == null || tag.method_10711() != type) {
            return null;
        }
        return tag;
    }

    @Nullable
    protected <T extends class_2520> T getTag(String key, CcaNbtType<T> type) {
        class_2520 ret = this.getTag(key, type.getId());
        return (T)ret;
    }

    protected Set<String> getKeys() {
        class_2487 rootTag = this.getRootTag();
        return rootTag == null ? Collections.emptySet() : rootTag.method_10541();
    }

    @Override
    @ApiStatus.Experimental
    public void onTagInvalidated() {
        this.rootTag = this.stack.method_7941(this.getRootTagKey());
    }

    @Deprecated
    public final void readFromNbt(class_2487 tag) {
        this.getOrCreateRootTag().method_10543(tag);
    }

    @Deprecated
    public final void writeToNbt(class_2487 tag) {
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return 487;
    }

    private void setRootTagKey(String rootTagKey) {
        this.rootTagKey = rootTagKey;
        this.onTagInvalidated();
    }

    @ApiStatus.Internal
    public static <C extends ItemComponent> ComponentFactory<class_1799, C> wrapFactory(ComponentKey<? super C> key, ComponentFactory<class_1799, C> factory) {
        String rootTagKey = key.getId().toString();
        return i -> {
            ItemComponent c = (ItemComponent)factory.createComponent(i);
            c.setRootTagKey(rootTagKey);
            return c;
        };
    }
}

